clc
clear all
close all

%%
freq=5.9*1e9; 
P0=1;N=2;
ratevalue=9.6;
SNR_rng=0:2:50;
msg_length=1000;
rx_devices=1000; 
tx_devices=1000; 
mess_tx=randsrc(1,msg_length,0:1);
len=length(mess_tx);
mess_tx1=reshape(mess_tx,[len/2 2]);
data_de=bi2de(mess_tx1,'left-msb');
M= 4;
qpsk_mod_obj=modem.qammod('M', M, 'PhaseOffset',pi/2,'SymbolOrder', 'Gray','InputType', 'integer');
mod_signal=modulate(qpsk_mod_obj,data_de);
mess_bit_len=length(mod_signal);
mod_signal=sqrt(P0/(N*ratevalue))*mod_signal;
mod_data=1/sqrt(2)*kron(reshape(mod_signal,tx_devices,mess_bit_len/tx_devices),ones(1,tx_devices)) ; 
et0=1;
fs=1/2;
no_of_indirect_path=1000;
no_of_directpath=900;
epselonn=1e-6;

for kind1=1:no_of_directpath
    for p=1:1+1
        vector_corr(p)=besselj(0,2*pi*freq*(p-1)/(fs*1000));  %Jakes' model
    end
    auto_correaltion_matrix=toeplitz(vector_corr(1:1))+eye(1)*epselonn; 
    AR_parameters=-inv(auto_correaltion_matrix)*vector_corr(2:1+1)'; 
    segma_u=auto_correaltion_matrix(1,1)+vector_corr(2:1+1)*AR_parameters;
    chan_mdl=filter(1,[1 AR_parameters.'],wgn((2*rx_devices),mess_bit_len,10*log10(segma_u),'complex')); 
    ch_src_dest{kind1}=wgn((2*rx_devices),mess_bit_len,freq,fs);
    wns_src_dest{kind1}=wgn(2*rx_devices,mess_bit_len,et0/2,'complex');
    
end
for kin_path=1:no_of_indirect_path
    for p=1:1+1
        vector_corr(p)=besselj(0,2*pi*freq*(p-1)/(fs*1000));  %Jakes' model
    end
    auto_correaltion_matrix=toeplitz(vector_corr(1:1))+eye(1)*epselonn; 
    AR_parameters=-inv(auto_correaltion_matrix)*vector_corr(2:1+1)'; 
    segma_u=auto_correaltion_matrix(1,1)+vector_corr(2:1+1)*AR_parameters;
    chan_mdl=filter(1,[1 AR_parameters.'],wgn((2*rx_devices),mess_bit_len,10*log10(segma_u),'complex')); 
    ch_src_path1{kin_path}=wgn((2*rx_devices),mess_bit_len,freq,fs);
    wns_src_path1{kin_path}=wgn(2*rx_devices,mess_bit_len,et0/2,'complex');
    for p=1:1+1
        vector_corr(p)=besselj(0,2*pi*freq*(p-1)/(fs*1000));  %Jakes' model
    end
    auto_correaltion_matrix=toeplitz(vector_corr(1:1))+eye(1)*epselonn; 
    AR_parameters=-inv(auto_correaltion_matrix)*vector_corr(2:1+1)'; 
    segma_u=auto_correaltion_matrix(1,1)+vector_corr(2:1+1)*AR_parameters;
    chan_mdl=filter(1,[1 AR_parameters.'],wgn((2*rx_devices),mess_bit_len,10*log10(segma_u),'complex')); 
    ch_path1_dest{kin_path}=wgn((2*rx_devices),mess_bit_len,freq,fs);
    wns_path1_dest{kin_path}=wgn(2*rx_devices,mess_bit_len,et0/2,'complex');
end
SNR_rng1=SNR_rng+10;
for ind_val=1:length(SNR_rng)
    for kind1=1:no_of_directpath
       
ch_src_destmat{1,1}=ch_src_dest{kind1}(1,:);
ch_src_destmat{1,2}=ch_src_dest{kind1}(2,:);
ch_src_destmat{2,1}=ch_src_dest{kind1}(3,:);
ch_src_destmat{2,2}=ch_src_dest{kind1}(4,:);
ch_src_destmat1=ch_src_destmat;
ch_src_destmat1{3,1}=conj(ch_src_destmat{1,2});
ch_src_destmat1{3,2}=-conj(ch_src_destmat{1,1});
ch_src_destmat1{4,1}=conj(ch_src_destmat{2,2});
ch_src_destmat1{4,2}=-conj(ch_src_destmat{2,1});
final1=[];
final2=[];
noutfinal1=[];
noutfinal2=[];
[rr cc]=size(ch_src_destmat1);
ind=1;
ind1=1;
for k1=1:mess_bit_len    
    for k3=1:rr
        for k4=1:cc
            hmod1=ch_src_destmat1{k3,k4};
            hmodout(k3,k4)=hmod1(k1);
        end
    end
    youtx=hmodout*mod_data(:,ind);
    yout(1:4,ind1)=youtx;
    noutx=wns_src_dest{kind1}(1:4,ind);
    ind=ind+1;
    ind1=ind1+1;
    final1=[final1 youtx(1) youtx(3)];
    final2=[final2 youtx(2) youtx(4)];
    noutfinal1=[noutfinal1 noutx(1) noutx(3)];
    noutfinal2=[noutfinal2 noutx(2) noutx(4)];
end
    final1_rxs{kind1}=final1+10^(-SNR_rng(ind_val)/20)*noutfinal1;
    final2_rxs{kind1}=final2+10^(-SNR_rng(ind_val)/20)*noutfinal2
    end
    
    for kin_path=1:no_of_indirect_path
    ch_src_destmat{1,1}=ch_src_path1{kin_path}(1,:);
    ch_src_destmat{1,2}=ch_src_path1{kin_path}(2,:);
    ch_src_destmat{2,1}=ch_src_path1{kin_path}(3,:);
    ch_src_destmat{2,2}=ch_src_path1{kin_path}(4,:);
    ch_src_destmat1=ch_src_destmat;
    ch_src_destmat1{3,1}=conj(ch_src_destmat{1,2});
    ch_src_destmat1{3,2}=-conj(ch_src_destmat{1,1});
    ch_src_destmat1{4,1}=conj(ch_src_destmat{2,2});
    ch_src_destmat1{4,2}=-conj(ch_src_destmat{2,1});
    final1=[];
    final2=[];
    noutfinal1=[];
    noutfinal2=[];
    [rr cc]=size(ch_src_destmat1);
    ind=1;
    ind1=1;
    for k1=1:mess_bit_len
        for k3=1:rr
            for k4=1:cc
                hmod1=ch_src_destmat1{k3,k4};
                hmodout(k3,k4)=hmod1(k1);
            end
        end    
    youtx=hmodout*mod_data(:,ind);
    yout(1:4,ind1)=youtx;
    noutx=wns_src_path1{kin_path}(1:4,ind);  
    ind=ind+1;
    ind1=ind1+1;
    final1=[final1 youtx(1) youtx(3)];
    final2=[final2 youtx(2) youtx(4)];
    noutfinal1=[noutfinal1 noutx(1) noutx(3)];
    noutfinal2=[noutfinal2 noutx(2) noutx(4)];
    end
        final1_rxr1{kin_path}=final1+10^(-SNR_rng(ind_val)/20)*noutfinal1;
        final2_rxr1{kin_path}=final2+10^(-SNR_rng(ind_val)/20)*noutfinal2;
    end
    
   
    for kin_path=1:no_of_indirect_path
        ch_src_rly1{1,1}=ch_src_path1{kin_path}(1,:);
        ch_src_rly1{1,2}=ch_src_path1{kin_path}(2,:);
        ch_src_rly1{2,1}=ch_src_path1{kin_path}(3,:);
        ch_src_rly1{2,2}=ch_src_path1{kin_path}(4,:);
        ch_src_rly11=ch_src_rly1;
        ch_src_rly11{3,1}=conj(ch_src_rly1{1,2});
        ch_src_rly11{3,2}=-conj(ch_src_rly1{1,1});
        ch_src_rly11{4,1}=conj(ch_src_rly1{2,2});
        ch_src_rly11{4,2}=-conj(ch_src_rly1{2,1});
        len=length(final1_rxr1{kin_path});
        indm=1;
        for km=1:2:len-1    
            yrout1=final1_rxr1{kin_path}(km:km+1);
            yrout2=final2_rxr1{kin_path}(km:km+1);
            yrout(1)=yrout1(1);
            yrout(3)=yrout1(2);
            yrout(2)=yrout2(1);
            yrout(4)=yrout2(2);
            youtrx(1:4,indm)=yrout.';
            indm=indm+1;
        end
       for k1=1:mess_bit_len
         for k3=1:4
             for k4=1:2
                 hmod1=ch_src_rly11{k3,k4};
                 hmodout(k3,k4)=hmod1(k1);
             end
         end
         yout_rx_final(:,k1)=youtrx(:,k1);
       end
      yout_rx_final1=[yout_rx_final(1,1:2:end);
      yout_rx_final(2,1:2:end)];   
      rx_data=yout_rx_final1(:).';
      
    final_rx_data=rx_data;
    con2=qpsk_mod_obj.constellation;
    final_contell=repmat(con2(:),[1 length(final_rx_data)]);
    final_rx2=repmat(final_rx_data,[4 1]);
    diff_val=final_contell-final_rx2;
    [val loc1]=min(diff_val);
    symb=qpsk_mod_obj.SymbolMapping;
    m1=symb(loc1);
    demod_signal=de2bi(m1,2,'left-msb');
    data_rx=demod_signal(:).';   
    mess_tx=data_rx;
    len=length(mess_tx);
    mess_tx1=reshape(mess_tx,[len/2 2]);
    data_de=bi2de(mess_tx1,'left-msb');
    M= 4;
    qpsk_mod_obj=modem.qammod('M', M, 'PhaseOffset',pi/2,'SymbolOrder', 'Gray','InputType', 'integer');
    mod_signal=modulate(qpsk_mod_obj,data_de);
    mess_bit_len=length(mod_signal);
    stbc_data=1/sqrt(2)*kron(reshape(mod_signal,tx_devices,mess_bit_len/tx_devices),ones(1,tx_devices)) ;
    rly1_tx_data{kin_path}=stbc_data;

    end   
    for kin_path=1:no_of_indirect_path   
        ch_src_destmat{1,1}=ch_path1_dest{kin_path}(1,:);
        ch_src_destmat{1,2}=ch_path1_dest{kin_path}(2,:);
        ch_src_destmat{2,1}=ch_path1_dest{kin_path}(3,:);
        ch_src_destmat{2,2}=ch_path1_dest{kin_path}(4,:);
        ch_src_destmat1=ch_src_destmat;
        ch_src_destmat1{3,1}=conj(ch_src_destmat{1,2});
        ch_src_destmat1{3,2}=-conj(ch_src_destmat{1,1});
        ch_src_destmat1{4,1}=conj(ch_src_destmat{2,2});
        ch_src_destmat1{4,2}=-conj(ch_src_destmat{2,1});
        final1=[];
        final2=[];
        noutfinal1=[];
        noutfinal2=[];
        [rr cc]=size(ch_src_destmat1);
        ind=1;
        ind1=1;
        for k1=1:mess_bit_len   
            for k3=1:rr
                for k4=1:cc
                    hmod1=ch_src_destmat1{k3,k4};
                    hmodout(k3,k4)=hmod1(k1);
                end
            end
    youtx=hmodout*rly1_tx_data{kin_path}(:,ind);
    yout(1:4,ind1)=youtx;
    noutx=wns_path1_dest{kin_path}(1:4,ind);
    ind=ind+1;
    ind1=ind1+1;
    final1=[final1 youtx(1) youtx(3)];
    final2=[final2 youtx(2) youtx(4)];    
    noutfinal1=[noutfinal1 noutx(1) noutx(3)];
    noutfinal2=[noutfinal2 noutx(2) noutx(4)];
        end
        final1_rxr1d{kin_path}=final1+10^(-SNR_rng1(ind_val)/20)*noutfinal1;
        final2_rxr1d{kin_path}=final2+10^(-SNR_rng1(ind_val)/20)*noutfinal2;
        
    end
    no_of_bandit=no_of_indirect_path;
    no_of_trials=100;
    sigma=0.1;
    randn('seed',0); 
    meanqval=mvnrnd( zeros(no_of_bandit,no_of_indirect_path), eye(no_of_indirect_path) ); 
    epsival=0.1; 
    qrandval=mvnrnd( meanqval, eye(no_of_indirect_path) );
    avg_rwd=zeros(length(epsival),no_of_trials); 
    per_act=zeros(length(epsival),no_of_trials); 
    cum_rwd=zeros(length(epsival),no_of_trials); 
    final_prob=zeros(length(epsival),no_of_trials); 
    for ei=1:length(epsival), 
      tepsival=epsival(ei); 
      data1=zeros(size(qrandval));  
      data2=ones( no_of_bandit, no_of_indirect_path ); 
      qdata=data1;             
      all_rwd=zeros(no_of_bandit,no_of_trials); 
      max_act=zeros(no_of_bandit,no_of_trials); 
      for bandit_ind=1:no_of_bandit, 
        for no_of_ply=1:no_of_trials, 
          if( rand(1) <= tepsival ) 
            [dum,arm] = histc(rand(1),linspace(0,1+eps,no_of_indirect_path+1));
          else                  
            [dum,arm] = max( data1(bandit_ind,:) ); 
          end
          [dum,bestArm] = max( meanqval(bandit_ind,:) );
          if( arm==bestArm ) 
              max_act(bandit_ind,no_of_ply) = 1; 
          end
          reward = meanqval(bandit_ind,arm) + sigma*randn(1); 
          all_rwd(bandit_ind,no_of_ply) = reward; 
          data2(bandit_ind,arm) = data2(bandit_ind,arm)+1;
          qdata(bandit_ind,arm) = qdata(bandit_ind,arm)+reward; 
          data1(bandit_ind,arm) = qdata(bandit_ind,arm)/data2(bandit_ind,arm); 
        end
      end
  cs_f1=cumsum(max_act,2)./cumsum(ones(size(max_act)),2);
  cs_f2=mean(cs_f1,1);
  final_prob(ei,:) = cs_f2(:).';
end
optisel=bestArm;
%%
    for kind1=1:no_of_directpath
        ch_src_rly1{1,1}=ch_src_dest{kind1}(1,:);
        ch_src_rly1{1,2}=ch_src_dest{kind1}(2,:);
        ch_src_rly1{2,1}=ch_src_dest{kind1}(3,:);
        ch_src_rly1{2,2}=ch_src_dest{kind1}(4,:);
        ch_src_rly11=ch_src_rly1;
        ch_src_rly11{3,1}=conj(ch_src_rly1{1,2});
        ch_src_rly11{3,2}=-conj(ch_src_rly1{1,1});
        ch_src_rly11{4,1}=conj(ch_src_rly1{2,2});
        ch_src_rly11{4,2}=-conj(ch_src_rly1{2,1});
        len=length(final1_rxs{kind1});
        indm=1;
        for km=1:2:len-1            
            yrout1=final1_rxs{kind1}(km:km+1);
            yrout2=final2_rxs{kind1}(km:km+1);
             yrout(1)=yrout1(1);
             yrout(3)=yrout1(2);             
             yrout(2)=yrout2(1);
             yrout(4)=yrout2(2);             
             youtrx(1:4,indm)=yrout.';
             indm=indm+1;
        end       
       for k1=1:mess_bit_len           
         for k3=1:4
             for k4=1:2                 
                hmod1=ch_src_rly11{k3,k4};                
                 hmodout(k3,k4)=hmod1(k1);
             end
         end
         yout_rx_final(:,k1)=youtrx(:,k1);
       end
        yout_rx_final1=[yout_rx_final(1,1:2:end);yout_rx_final(2,1:2:end)];   
        rx_data=yout_rx_final1(:).';
        final_rx_data=rx_data;
        con2=qpsk_mod_obj.constellation;
        final_contell=repmat(con2(:),[1 length(final_rx_data)]);
        final_rx2=repmat(final_rx_data,[4 1]);
        diff_val=final_contell-final_rx2;
        [val loc1]=min(diff_val);
        symb=qpsk_mod_obj.SymbolMapping;
        m1=symb(loc1);
        demod_signal=de2bi(m1,2,'left-msb');
        data_rx=demod_signal(:).';
        data_final_rxed1= data_rx;
        [errval,errrate1(kind1)]=biterr(mess_tx,data_final_rxed1);
        end
 
        self.epsilon = 0.6;
        reward=0.01;
        self.n_arms = 1000;              
        self.trials = zeros(1,1000);     
        self.rewards = zeros(1,1000);     
        self.scores = ones(1,1000);      
        if  reward == 0.01                  
          self.epsilon = 0.1;         
        else                            
           self.epsilon = 0.6;    
        end
        for kiter=1:1000
        if rand <= self.epsilon            
            choice = randi(self.n_arms);    
         else                               
            [~, choice] =max(self.scores(end,:)); 
           end       
        self.trials(arm) =  self.trials(arm) + 1; 
        self.rewards(arm) = self.rewards(arm) + reward; 
        end
selval=choice;
    for kin_path=selval        
        ch_src_rly1{1,1}=ch_path1_dest{kin_path}(1,:);
        ch_src_rly1{1,2}=ch_path1_dest{kin_path}(2,:);
        ch_src_rly1{2,1}=ch_path1_dest{kin_path}(3,:);
        ch_src_rly1{2,2}=ch_path1_dest{kin_path}(4,:);
        ch_src_rly11=ch_src_rly1;
        ch_src_rly11{3,1}=conj(ch_src_rly1{1,2});
        ch_src_rly11{3,2}=-conj(ch_src_rly1{1,1});
        ch_src_rly11{4,1}=conj(ch_src_rly1{2,2});
        ch_src_rly11{4,2}=-conj(ch_src_rly1{2,1});
        len=length(final1_rxr1d{kin_path});
        indm=1;
        for km=1:2:len-1    
            yrout1=final1_rxr1d{kin_path}(km:km+1);
            yrout2=final2_rxr1d{kin_path}(km:km+1);
            yrout(1)=yrout1(1);
             yrout(3)=yrout1(2);     
             yrout(2)=yrout2(1);
             yrout(4)=yrout2(2);
             youtrx(1:4,indm)=yrout.';
             indm=indm+1;
        end      
       for k1=1:mess_bit_len           
         for k3=1:4
             for k4=1:2
                hmod1=ch_src_rly11{k3,k4};
                 hmodout(k3,k4)=hmod1(k1);
             end
         end
         yout_rx_final(1:2,k1)=pinv(hmodout)*youtrx(:,k1);
       end
      yout_rx_final1=[yout_rx_final(1,1:2:end);yout_rx_final(2,1:2:end)];   
      rx_data=yout_rx_final1(:).';
    final_rx_data=rx_data;
    qpsk_mod_obj1=modem_object_create(4);
    con2=qpsk_mod_obj1.constellation;
    final_contell=repmat(con2(:),[1 length(final_rx_data)]);
    final_rx2=repmat(final_rx_data,[4 1]);
    diff_val=final_contell-final_rx2;
    [val loc1]=min(diff_val);
    symb=qpsk_mod_obj1.SymbolMapping;
    m1=symb(loc1);
    demod_signal=de2bi(m1,2,'left-msb');
    data_rx=demod_signal(:).';
    data_final_rxed2;
    [errval,errrate2(kin_path)]=biterr(mess_tx,data_final_rxed2);
    end
  snrfinal(ind_val)=SNR_rng(ind_val);
  resltdata(ind_val)=1-mean([errrate1 errrate2]);   
end
%%
mess_tx=randsrc(1,msg_length,0:1); 
len=length(mess_tx);
mess_tx1=reshape(mess_tx,[len/2 2]);
data_de=bi2de(mess_tx1,'left-msb');
qpsk_mod_obj=modem_object_create(4); 
mod_signal=modulation_process(qpsk_mod_obj,data_de);
mess_bit_len=length(mod_signal);
mod_signal=sqrt(P0/(N*ratevalue))*mod_signal;
mod_data=1/sqrt(2)*kron(reshape(mod_signal,tx_devices,mess_bit_len/tx_devices),ones(1,tx_devices)) ; 
et0=1;
fs=1/2;
no_of_cell_bs=8;
no_of_bs=8;
for kbs1=1:no_of_bs
    
    ch_src_dest{kbs1}=ar_channelmodel_process(1,2*rx_devices,mess_bit_len,freq,fs);
    wns_src_dest{kbs1}=wgn(2*rx_devices,mess_bit_len,et0/2,'complex');
    
end
for kbs=1:no_of_cell_bs
    ch_src_rly1{kbs}=ar_channelmodel_process(1,2*rx_devices,mess_bit_len,freq,fs); 
    wns_src_rly1{kbs}=wgn(2*rx_devices,mess_bit_len,et0/2,'complex');
    ch_rly1_dest{kbs}=ar_channelmodel_process(1,2*rx_devices,mess_bit_len,freq,fs);
    wns_rly1_dest{kbs}=wgn(2*rx_devices,mess_bit_len,et0/2,'complex');
    end

for ind_val=1:length(SNR_rng)       
    for kbs1=1:no_of_bs        
        [final1s,final2s,noutfinal1s,noutfinal2s]=source_to_dest_tx(mod_data,mess_bit_len,ch_src_dest{kbs1},wns_src_dest{kbs1});
        final1_rxs{kbs1}=final1s+10^(-SNR_rng(ind_val)/20)*noutfinal1s;
        final2_rxs{kbs1}=final2s+10^(-SNR_rng(ind_val)/20)*noutfinal2s;
    end
    for kbs=1:no_of_cell_bs    
        [final1r1,final2r1,noutfinal1r1,noutfinal2r1]=source_to_relay1_tx(mod_data,mess_bit_len,ch_src_rly1{kbs},wns_src_rly1{kbs});
        final1_rxr1{kbs}=final1r1+10^(-SNR_rng(ind_val)/20)*noutfinal1r1;
        final2_rxr1{kbs}=final2r1+10^(-SNR_rng(ind_val)/20)*noutfinal2r1;
    end
    for kbs=1:no_of_cell_bs
        rly1_tx_data{kbs}=decode_forward_rly1_process(final1_rxr1{kbs},final2_rxr1{kbs},mess_bit_len,ch_src_rly1{kbs},tx_devices);
   end
    for kbs=1:no_of_cell_bs
        [final1r1d,final2r1d,noutfinal1r1d,noutfinal2r1d]=relay1_to_dest_tx(rly1_tx_data{kbs},mess_bit_len,ch_rly1_dest{kbs},wns_rly1_dest{kbs});
        final1_rxr1d{kbs}=final1r1d+10^(-SNR_rng(ind_val)/20)*noutfinal1r1d;
        final2_rxr1d{kbs}=final2r1d+10^(-SNR_rng(ind_val)/20)*noutfinal2r1d;
    end
    selval=multi_arm_bandit_process(100,no_of_cell_bs);
    for kbs1=1:no_of_bs
        data_final_rxed1=decode_process_destination(final1_rxs{kbs1},final2_rxs{kbs1},ch_src_dest{kbs1},mess_bit_len);
        [errval,errrate1(kbs1)]=biterr(mess_tx,data_final_rxed1);
    end
    for kbs=selval
        data_final_rxed2=decode_process_destination(final1_rxr1d{kbs},final2_rxr1d{kbs},ch_rly1_dest{kbs},mess_bit_len);
        [errval,errrate2(kbs)]=biterr(mess_tx,data_final_rxed2);
    end
    snrfinal(ind_val)=SNR_rng(ind_val);
    resltdata(ind_val)=1-mean([errrate1 errrate2]);
end
len=length(final1_rxs);

figure,plot(snrfinal,resltdata_cs,'r-o');
hold on,plot(snrfinal,resltdata,'b-o');
xlabel('SNR');
ylabel('Normalizaed Throughput');
grid on;
legend('Direct Mode','Indirect Mode');